/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xrtdefs.h 
 *       Type Definitions for Requester-Target (RT) Functions
 * -----------------------------------------------------------------*/

#ifndef XRTDEFS_H_INCLUDED                               
#define XRTDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  Requester generics ************************************************
 *******************************************************************/

#define BX_RTGENPROP_SIZE     6

CLI typedef enum {
  BX_RTGEN_NUMBEH,      /* @numbeh   */
  BX_RTGEN_NUMBEHG0,    /* @numbehg0 */
  BX_RTGEN_NUMBEHG1,    /* @numbehg1 */
  BX_RTGEN_NUMBEHG2,    /* @numbehg2 */
  BX_RTGEN_NUMBEHG3,    /* @numbehg3 */
  BX_RTGEN_NUMBEHG4     /* @numbehg4 */
} bx_rtgentype;

/********************************************************************
  Requester behavior ************************************************
 *******************************************************************/

CLI typedef enum {
  BX_RTBEH_DECSPEED,    /* @decspeed    */  /* Group 3 */
  BX_RTBEH_ACK64,       /* @ack64       */  /* Group 3 */
  BX_RTBEH_INITIAL,     /* @initial     */  /* Group 1 */
  BX_RTBEH_LATENCY,     /* @latency     */  /* Group 1 */
  BX_RTBEH_SUBSEQ,      /* @subseq      */  /* Group 2 */
  BX_RTBEH_SUBSEQPHASE, /* @subseqphase */  /* Group 2 */
  BX_RTBEH_REPEAT,      /* @repeat      */  /* Group 0 */
  BX_RTBEH_ENUMSIZE     /* $enumsize */
} bx_rtbehtype;

#define BX_RBEHPROP_SIZE   ((bx_int32) BX_RTBEH_ENUMSIZE)

CLI  /* DEF_START ~G_BX_RTBEH_DECSPEED */
#define BX_RTBEH_DECSPEED_A  0   /* @A @decspeeda */
#define BX_RTBEH_DECSPEED_B  1   /* @B @decspeedb */
#define BX_RTBEH_DECSPEED_C  2   /* @C @decspeedc */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RTBEH_INITIAL */
#define BX_RTBEH_INITIAL_ACCEPT 0  /* @Accept */
#define BX_RTBEH_INITIAL_SINGLE 1  /* @Single */
#define BX_RTBEH_INITIAL_RETRY  2  /* @Retry  */
#define BX_RTBEH_INITIAL_TABORT 3  /* @TAbort */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_RTBEH_SUBSEQ */
#define BX_RTBEH_SUBSEQ_ACCEPT     0   /* @Accept     */
#define BX_RTBEH_SUBSEQ_DISCONNECT 1   /* @Disconnect */
#define BX_RTBEH_SUBSEQ_TABORT     2   /* @Tabort */
CLI  /* DEF_END */


/********************************************************************
  Requester behavior groups *****************************************
 *******************************************************************/

CLI typedef enum {
  BX_RTBEHGRP_0 = 1UL << 0UL, /* @rtbehgrp0 */
  BX_RTBEHGRP_1 = 1UL << 1UL, /* @rtbehgrp1 */
  BX_RTBEHGRP_2 = 1UL << 2UL, /* @rtbehgrp2 */
  BX_RTBEHGRP_3 = 1UL << 3UL, /* @rtbehgrp3 */
  BX_RTBEHGRP_4 = 1UL << 4UL, /* @rtbehgrp4 */
  BX_RTBEHGRP_ENUMSIZE        /* $enumsize  */
} bx_rtbehgrptype;

#define BX_RTBEHGRP_SIZE BX_RTBEHGRP_ENUMSIZE

#endif
